<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-header" style="background: url(<?php echo e(asset('assets/img/banner1.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="breadcrumb-wrapper">
                        <h2 class="product-title">My Favorites</h2>
                        <ol class="breadcrumb">
                            <li><a href="#">Home /</a></li>
                            <li class="current">My Favorites</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user_content'); ?>



    <div id="content" class="section-padding">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.user_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-sm-12 col-md-9 col-lg-9">
                    <div class="page-content">
                        <div class="inner-box">
                            <div class="dashboard-box">
                                <h2 class="dashbord-title">My Favorites</h2>
                            </div>

                            <div class="dashboard-wrapper">
                                <table class="table table-responsive dashboardtable tablemyads">
                                    <thead>
                                    <tr>
                                        <th>
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="checkedall">
                                                <label class="custom-control-label" for="checkedall"></label>
                                            </div>
                                        </th>
                                        <th>Photo</th>
                                        <th>Title</th>
                                        <th>Category</th>
                                        <th>Ad Status</th>
                                        <th>Price</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr data-category="<?php echo e($ad->is_active == 1 ? 'active' : 'inactive'); ?>">
                                            <td>
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="adone">
                                                    <label class="custom-control-label" for="adone"></label>
                                                </div>
                                            </td>
                                            <td class="photo"><img class="img-fluid"
                                                                   src="<?php echo e(url('/openGateAds').'/'.$ad->photos->where('type','main_image')->pluck('image_path')->first()); ?>"
                                                                   alt="ad photo"></td>
                                            <td data-title="Title">
                                                <h3><?php echo e($ad->title); ?></h3>
                                            </td>
                                            <td data-title="Category"><span
                                                    class="adcategories"> <?php echo e($ad->category->name); ?></span></td>
                                            <td data-title="Ad Status"><span
                                                    class="adstatus adstatus<?php echo e($ad->is_active == 1 ? 'active' : 'inactive'); ?>"><?php echo e($ad->is_active == 1 ? 'active' : 'inactive'); ?></span>
                                            </td>
                                            <td data-title="Price">
                                                <h3>Ksh <?php echo e(number_format($ad->price, 0)); ?></h3>
                                            </td>
                                            <td data-title="Action">
                                                <div class="btns-actions">
                                                    <a class="btn-action btn-view" href="#">View</a>
                                                    <a class="btn-action btn-edit" href="#">Edit</a>
                                                    <a class="btn-action btn-delete" href="#">Delete</a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('pages.user_dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\OpenGateAd\resources\views/pages/acc_fav_ads.blade.php ENDPATH**/ ?>